#include <iostream>
#include <vector>

using namespace std;

bool ab_is_better_than_ba(string& a, string& b) {
  string ab = a + b;
  string ba = b + a;
  return ab > ba;
}

void merge(vector<string> &a, int l, int m, int r) {
  int left = l;
  int right = m;
  vector<string> ans;
  for (int i = l; i < r; ++i) {
    if (left >= m) {
      ans.push_back(a[right]);
      right++;
    } else if (right >= r) {
      ans.push_back(a[left]);
      left++;
    } else if (!ab_is_better_than_ba(a[right], a[left])) {
      ans.push_back(a[left]);
      left++;
    } else {
      ans.push_back(a[right]);
      right++;
    }
  }
  for (int i = l; i < r; ++i) {
    a[i] = ans[i - l];
  }
}


void sort(vector<string> &a, int l, int r) {
  int m = (l + r) / 2;
  if (r - l < 2)
    return;
  sort(a, l, m);
  sort(a, m, r);
  merge(a, l, m, r);
}


int main() {
  int n;
  cin >> n;
  vector<string> v;
  for (int i = 0; i < n; i++) {
    string inp;
    cin >> inp;
    v.push_back(inp);
  }
  sort(v, 0, n);
  for (int i = 0; i < n; i++) {
    cout << v[i];
  }
}